<?php
/*
 FusionPBX
 Version: MPL 1.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

 Software distributed under the License is distributed on an "AS IS" basis,
 WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 for the specific language governing rights and limitations under the
 License.

 The Original Code is FusionPBX

 The Initial Developer of the Original Code is
 Mark J Crane <markjcrane@fusionpbx.com>
 Portions created by the Initial Developer are Copyright (C) 2016-2023
 the Initial Developer. All Rights Reserved.
*/

//includes files
	require_once dirname(__DIR__, 2) . "/resources/require.php";
	require_once "resources/check_auth.php";
	require_once "resources/paging.php";

//check permissions
	if (permission_exists('email_template_view')) {
		//access granted
	}
	else {
		echo "access denied";
		exit;
	}

//add multi-lingual support
	$language = new text;
	$text = $language->get();

//set from session variables
	$list_row_edit_button = !empty($_SESSION['theme']['list_row_edit_button']['boolean']) ? $_SESSION['theme']['list_row_edit_button']['boolean'] : 'false';

//get posted data
	if (!empty($_POST['email_templates'])) {
		$action = $_POST['action'];
		$category = $_POST['category'] ?? null;
		$search = $_POST['search'];
		$email_templates = $_POST['email_templates'];
	}

//process the http post data by action
	if (!empty($action) && !empty($email_templates)) {
		switch ($action) {
			case 'copy':
				if (permission_exists('email_template_add')) {
					$obj = new email_templates;
					$obj->copy($email_templates);
				}
				break;
			case 'toggle':
				if (permission_exists('email_template_edit')) {
					$obj = new email_templates;
					$obj->toggle($email_templates);
				}
				break;
			case 'delete':
				if (permission_exists('email_template_delete')) {
					$obj = new email_templates;
					$obj->delete($email_templates);
				}
				break;
		}

		header('Location: email_templates.php?'.(!empty($search) ? '&search='.urlencode($search) : null).(!empty($category) ? '&category='.urlencode($category) : null));
		exit;
	}

//get variables used to control the order
	$order_by = $_GET["order_by"] ?? '';
	$order = $_GET["order"] ?? '';

//add the category
	$category = strtolower($_GET["category"] ?? '');
	if ($category) {
		$sql_category = "and (";
		$sql_category .= " lower(template_category) = :category";
		$sql_category .= ") ";
		$parameters['category'] = $category;
	}

//add the search term
	$search = strtolower($_GET["search"] ?? '');
	if (!empty($search)) {
		$sql_search = " (";
		$sql_search .= " lower(template_language) like :search ";
		//$sql_search .= " or lower(template_category) like :search ";
		$sql_search .= " or lower(template_subcategory) like :search ";
		$sql_search .= " or lower(template_subject) like :search ";
		$sql_search .= " or lower(template_body) like :search ";
		$sql_search .= " or lower(template_type) like :search ";
		$sql_search .= " or lower(template_enabled) like :search ";
		$sql_search .= " or lower(template_description) like :search ";
		$sql_search .= ") ";
		$parameters['search'] = '%'.$search.'%';
	}

//prepare to page the results
	$sql = "select count(*) from v_email_templates where true ";
	if (!empty($_GET['show']) && $_GET['show'] == "all" && permission_exists('email_template_all')) {
		if (!empty($sql_search)) {
			$sql .= "and ".$sql_search;
		}
	}
	else {
		$sql .= "and (domain_uuid = :domain_uuid or domain_uuid is null) ";
		if (!empty($sql_search)) {
			$sql .= "and ".$sql_search;
		}
		$parameters['domain_uuid'] = $domain_uuid;
	}
	$sql .= $sql_category ?? '';
	$database = new database;
	$num_rows = $database->select($sql, $parameters ?? '', 'column');

//prepare to page the results
	$rows_per_page = (!empty($_SESSION['domain']['paging']['numeric'])) ? $_SESSION['domain']['paging']['numeric'] : 50;
	$param = "&search=".$search;
	if (!empty($_GET['show']) == "all" && permission_exists('email_template_all')) {
		$param .= "&show=all";
	}
	$page = isset($_GET['page']) ? $_GET['page'] : 0;
	list($paging_controls, $rows_per_page) = paging($num_rows, $param, $rows_per_page);
	list($paging_controls_mini, $rows_per_page) = paging($num_rows, $param, $rows_per_page, true);
	$offset = $rows_per_page * $page;

//get the list
	$sql = str_replace('count(*)', '*', $sql);
	if ($order_by) {
		$sql .= order_by($order_by, $order);
	}
	else {
		$sql .= "order by domain_uuid, template_language asc, template_category asc, template_subcategory asc, template_type asc, template_description asc ";
	}
	$sql .= limit_offset($rows_per_page, $offset);
	$database = new database;
	$result = $database->select($sql, $parameters ?? '', 'all');
	unset($sql, $parameters);

//get email template categories
	$sql = "select distinct template_category from v_email_templates ";
	$sql .= "order by template_category asc ";
	$database = new database;
	$rows = $database->select($sql, $parameters ?? '', 'all');
	if (!empty($rows)) {
		foreach ($rows as $row) {
			$template_categories[$row['template_category']] = ucwords(str_replace('_',' ',$row['template_category']));
		}
	}
	unset($sql, $parameters);

//create token
	$object = new token;
	$token = $object->create($_SERVER['PHP_SELF']);

//additional includes
	$document['title'] = $text['title-email_templates'];
	require_once "resources/header.php";

//show the content
	echo "<div class='action_bar' id='action_bar'>\n";
	echo "	<div class='heading'><b>".$text['title-email_templates']." (".$num_rows.")</b></div>\n";
	echo "	<div class='actions'>\n";
	if (permission_exists('email_template_add')) {
		echo button::create(['type'=>'button','label'=>$text['button-add'],'icon'=>$_SESSION['theme']['button_icon_add'],'id'=>'btn_add','link'=>'email_template_edit.php']);
	}
	if (permission_exists('email_template_add') && $result) {
		echo button::create(['type'=>'button','label'=>$text['button-copy'],'icon'=>$_SESSION['theme']['button_icon_copy'],'id'=>'btn_copy','name'=>'btn_copy','style'=>'display: none;','onclick'=>"modal_open('modal-copy','btn_copy');"]);
	}
	if (permission_exists('email_template_edit') && $result) {
		echo button::create(['type'=>'button','label'=>$text['button-toggle'],'icon'=>$_SESSION['theme']['button_icon_toggle'],'id'=>'btn_toggle','name'=>'btn_toggle','style'=>'display: none;','onclick'=>"modal_open('modal-toggle','btn_toggle');"]);
	}
	if (permission_exists('email_template_delete') && $result) {
		echo button::create(['type'=>'button','label'=>$text['button-delete'],'icon'=>$_SESSION['theme']['button_icon_delete'],'id'=>'btn_delete','name'=>'btn_delete','style'=>'display: none;','onclick'=>"modal_open('modal-delete','btn_delete');"]);
	}
	echo 		"<form id='form_search' class='inline' method='get'>\n";
	if (permission_exists('email_template_all')) {
		if (!empty($_GET['show']) && $_GET['show'] == 'all') {
			echo "		<input type='hidden' name='show' value='all'>";
		}
		else {
			echo button::create(['type'=>'button','label'=>$text['button-show_all'],'icon'=>$_SESSION['theme']['button_icon_all'],'link'=>'?show=all']);
		}
	}
	echo 		"<select name='category' id='category' class='formfld' style='margin-left: 18px;' onchange=\"$('#form_search').submit();\">\n";
	echo 			"<option value='' ".(!$category ? "selected='selected'" : null)." disabled='disabled'>".$text['label-category']."...</option>\n";
	echo 			"<option value=''></option>\n";
	if (!empty($template_categories)) {
		foreach ($template_categories as $template_category_value => $template_category_label) {
			echo "<option value='".$template_category_value."' ".($category == $template_category_value ? "selected='selected'" : null).">".escape($template_category_label)."</option>\n";
		}
	}
	echo 		"</select>\n";
	echo 		"<input type='text' class='txt list-search' name='search' id='search' value=\"".escape($search)."\" placeholder=\"".$text['label-search']."\" onkeydown=''>";
	echo button::create(['label'=>$text['button-search'],'icon'=>$_SESSION['theme']['button_icon_search'],'type'=>'submit','id'=>'btn_search']);
	//echo button::create(['label'=>$text['button-reset'],'icon'=>$_SESSION['theme']['button_icon_reset'],'type'=>'button','id'=>'btn_reset','link'=>'email_templates.php','style'=>($search == '' ? 'display: none;' : null)]);
	if (!empty($paging_controls_mini)) {
		echo 	"<span style='margin-left: 15px;'>".$paging_controls_mini."</span>";
	}
	echo "		</form>\n";
	echo "	</div>\n";
	echo "	<div style='clear: both;'></div>\n";
	echo "</div>\n";

	if (permission_exists('email_template_add') && $result) {
		echo modal::create(['id'=>'modal-copy','type'=>'copy','actions'=>button::create(['type'=>'button','label'=>$text['button-continue'],'icon'=>'check','id'=>'btn_copy','style'=>'float: right; margin-left: 15px;','collapse'=>'never','onclick'=>"modal_close(); list_action_set('copy'); list_form_submit('form_list');"])]);
	}
	if (permission_exists('email_template_edit') && $result) {
		echo modal::create(['id'=>'modal-toggle','type'=>'toggle','actions'=>button::create(['type'=>'button','label'=>$text['button-continue'],'icon'=>'check','id'=>'btn_toggle','style'=>'float: right; margin-left: 15px;','collapse'=>'never','onclick'=>"modal_close(); list_action_set('toggle'); list_form_submit('form_list');"])]);
	}
	if (permission_exists('email_template_delete') && $result) {
		echo modal::create(['id'=>'modal-delete','type'=>'delete','actions'=>button::create(['type'=>'button','label'=>$text['button-continue'],'icon'=>'check','id'=>'btn_delete','style'=>'float: right; margin-left: 15px;','collapse'=>'never','onclick'=>"modal_close(); list_action_set('delete'); list_form_submit('form_list');"])]);
	}

	echo $text['title_description-email_template']."\n";
	echo "<br /><br />\n";

	echo "<form id='form_list' method='post'>\n";
	echo "<input type='hidden' id='action' name='action' value=''>\n";
	echo "<input type='hidden' name='search' value=\"".escape($search)."\">\n";

	echo "<table class='list'>\n";
	echo "<tr class='list-header'>\n";
	if (permission_exists('email_template_add') || permission_exists('email_template_edit') || permission_exists('email_template_delete')) {
		echo "	<th class='checkbox'>\n";
		echo "		<input type='checkbox' id='checkbox_all' name='checkbox_all' onclick='list_all_toggle(); checkbox_on_change(this);' ".(!empty($result) ?: "style='visibility: hidden;'").">\n";
		echo "	</th>\n";
	}
	if (!empty($_GET['show']) && $_GET['show'] == "all" && permission_exists('email_template_all')) {
		echo "<th>".$text['label-domain']."</th>\n";
		//echo th_order_by('domain_name', $text['label-domain'], $order_by, $order, null, null, $param);
	}
	echo th_order_by('template_language', $text['label-template_language'], $order_by, $order, null, "class='shrink'", $param);
	echo th_order_by('template_category', $text['label-template_category'], $order_by, $order, null, "class='pct-15'", $param);
	echo th_order_by('template_subcategory', $text['label-template_subcategory'], $order_by, $order, null, "class='pct-15'", $param);
	echo th_order_by('template_subject', $text['label-template_subject'], $order_by, $order, null, "class='hide-xs pct-30'", $param);
	echo th_order_by('template_type', $text['label-template_type'], $order_by, $order, null, null, $param);
	echo th_order_by('template_enabled', $text['label-template_enabled'], $order_by, $order, null, "class='center pct-10'", $param);
	echo th_order_by('template_description', $text['label-template_description'], $order_by, $order, null, "class='hide-sm-dn'", $param);
	if (permission_exists('email_template_edit') && $list_row_edit_button == 'true') {
		echo "	<td class='action-button'>&nbsp;</td>\n";
	}
	echo "</tr>\n";

	if (!empty($result)) {
		$x = 0;
		foreach($result as $row) {
			if (permission_exists('email_template_edit')) {
				$list_row_url = "email_template_edit.php?id=".urlencode($row['email_template_uuid']);
			}
			echo "<tr class='list-row' href='".$list_row_url."'>\n";
			if (permission_exists('email_template_add') || permission_exists('email_template_edit') || permission_exists('email_template_delete')) {
				echo "	<td class='checkbox'>\n";
				echo "		<input type='checkbox' name='email_templates[$x][checked]' id='checkbox_".$x."' value='true' onclick=\"checkbox_on_change(this); if (!this.checked) { document.getElementById('checkbox_all').checked = false; }\">\n";
				echo "		<input type='hidden' name='email_templates[$x][uuid]' value='".escape($row['email_template_uuid'])."' />\n";
				echo "	</td>\n";
			}
			if (!empty($_GET['show']) && $_GET['show'] == "all" && permission_exists('email_template_all')) {
				echo "	<td>";
				if (is_uuid($row['domain_uuid'])) {
					echo escape($_SESSION['domains'][$row['domain_uuid']]['domain_name']);
				}
				else {
					echo $text['label-global'];
				}
				echo "</td>\n";
			}
			echo "	<td>".escape($row['template_language'])."&nbsp;</td>\n";
			echo "	<td>".escape($row['template_category'])."&nbsp;</td>\n";
			echo "	<td>".escape($row['template_subcategory'])."&nbsp;</td>\n";
			echo "	<td class='overflow hide-xs'>";
			if (permission_exists('email_template_edit')) {
				echo "<a href='".$list_row_url."'>".escape($row['template_subject'])."</a>";
			}
			else {
				echo escape($row['template_subject']);
			}
			echo "	</td>\n";
			echo "	<td>".escape($row['template_type'])."&nbsp;</td>\n";
			if (permission_exists('email_template_edit')) {
				echo "	<td class='no-link center'>";
				echo button::create(['type'=>'submit','class'=>'link','label'=>$text['label-'.$row['template_enabled']],'title'=>$text['button-toggle'],'onclick'=>"list_self_check('checkbox_".$x."'); list_action_set('toggle'); list_form_submit('form_list')"]);
			}
			else {
				echo "	<td class='center'>";
				echo $text['label-'.$row['template_enabled']];
			}
			echo "	</td>\n";
			echo "	<td class='description overflow hide-sm-dn'>".escape($row['template_description'])."</td>\n";
			if (permission_exists('email_template_edit') && $list_row_edit_button == 'true') {
				echo "	<td class='action-button'>";
				echo button::create(['type'=>'button','title'=>$text['button-edit'],'icon'=>$_SESSION['theme']['button_icon_edit'],'link'=>$list_row_url]);
				echo "	</td>\n";
			}
			echo "</tr>\n";
			$x++;
		}
	}
	unset($result);

	echo "</table>\n";
	echo "<br />\n";
	echo "<div align='center'>".$paging_controls."</div>\n";

	echo "<input type='hidden' name='".$token['name']."' value='".$token['hash']."'>\n";

	echo "</form>\n";

//include the footer
	require_once "resources/footer.php";

?>
